<?php

declare(strict_types=1);

namespace App\Services\User;

use App\Repositories\Contracts\User\UserVideoRepositoryInterface;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

class UserVideoService
{
    public function __construct(
        protected UserVideoRepositoryInterface $userVideoRepository
    ) {}

    public function getAll(array $args = []): Builder
    {
        return $this->userVideoRepository->getAll($args);
    }

    public function find(int $id): ?Model
    {
        return $this->userVideoRepository->find($id);
    }

    public function findByUuid(string $uuid): ?Model
    {
        return $this->userVideoRepository->findByUuid($uuid);
    }

    public function findByUserId(int $userId, array $args = []): Builder
    {
        return $this->userVideoRepository->findByUserId($userId, $args);
    }

    public function create(array $data): Model
    {
        return $this->userVideoRepository->create($data);
    }

    public function update(int $id, array $data): bool
    {
        return $this->userVideoRepository->update($id, $data);
    }

    public function delete(int $id): bool
    {
        return $this->userVideoRepository->delete($id);
    }

    public function getLatestVideos()
    {
        return $this->getAll(['limit' => 3])->get();
    }

    public function getFeaturedVideos()
    {
        return $this->getAll(['limit' => 3])->get();
    }
}
