<?php

namespace App\View\Components\Frontend\Blog\ArticleDetail;

use App\Services\User\UserService;
use Illuminate\View\Component;

class ArticleMobileFooter extends Component
{
    public $article;
    public $user;
    public $userService;

    public function __construct(UserService $userService, $article)
    {
        $this->article = $article;
        $this->userService = $userService;
    }

    public function render()
    {
        $userStats = $this->userService->getUserReviewsStats($this->article->author->id);
        return view('components.frontend.blog.article-detail.article-mobile-footer', [
            'userStats' => $userStats,
        ]);
    }
}
