<?php

namespace App\View\Components\Frontend\Blog;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;
use App\Services\Blog\PostService;

class FeaturedPostSection extends Component
{
    public $postService;
    /**
     * Create a new component instance.
     */
    public function __construct(PostService $postService)
    {
        $this->postService = $postService;
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        $args = [
            'limit' => 3,
        ];
        $featuredPosts = $this->postService->getFeaturedPosts($args);
        return view('components.frontend.blog.featured-post-section', compact('featuredPosts'));
    }
}
