<?php

namespace App\View\Components\Frontend\Blog;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;
use App\Services\Blog\PostService;

class RelatedPosts extends Component
{
    public $postService;
    /**
     * Create a new component instance.
     */
    public function __construct(PostService $postService, public $post)
    {
        $this->postService = $postService;
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        $args = [
            'post' => $this->post,
            'limit' => 3
        ];
        $posts = $this->postService->getRelatedPosts($args);
        return view('components.frontend.blog.related-posts', compact('posts'));
    }
}
