<?php

namespace App\View\Components\Frontend\Classified\ClassifiedDetail;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;
use App\Services\Classified\ClassifiedService;
use Illuminate\Support\Collection;

class OurLatestClassifieds extends Component
{
    protected $classifiedService;
    public $latest_classifieds;
    /**
     * Create a new component instance.
     */
    public function __construct(ClassifiedService $classifiedService, public $classified)
    {
        $this->classifiedService = $classifiedService;
        $this->latest_classifieds = $this->getLatestClassifieds();
    }

    public function getLatestClassifieds(): Collection
    {
        $args = [
            'exclude_uuid' => $this->classified->uuid,
            'limit' => 3,
            'order_by' => 'created_at',
            'order'=>'desc'
        ];
        return $this->classifiedService->getAll($args)->get();
    }
    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.frontend.classified.classified-detail.our-latest-classifieds');
    }
}
