<?php

namespace App\View\Components\Frontend\Common;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\Support\Facades\Route;
use Illuminate\View\Component;

class BreadcrumbV2 extends Component
{
    /**
     * Create a new component instance.
     */
    public function __construct(
        public $name,
        public $params = array(),
    ) {
        // If this is a template page, get the slug from the route parameter
        if ($this->name === 'template.index' && empty($this->params)) {
            $routeParams = Route::current()->parameters();
            if (isset($routeParams['slug'])) {
                $this->params = $routeParams['slug'];
            }
        }
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        $routeName = Route::currentRouteName();
        return view('components.frontend.common.breadcrumb-v2', ['route_name' => $routeName]);
    }
}
