<?php

namespace App\View\Components\Frontend\Job\JobDetail;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;
use App\Models\Job\Job;
use App\Services\Job\JobService;

class RelatedJobs extends Component
{
    protected $jobService;
    public $relatedJobs;
    /**
     * Create a new component instance.
     */
    public function __construct(
        public Job $job,
    ) {
        $this->jobService = app(JobService::class);
        $this->relatedJobs = $this->getRelatedJobs();
    }
    public function getRelatedJobs()
    {
        $args = [
            'job' => $this->job,
            'limit' => 3,
        ];
        $relatedJobs = $this->jobService->getRelatedJobs($args);

        return $relatedJobs;
    }
    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.frontend.job.job-detail.related-jobs');
    }
}
