<?php

namespace App\View\Components\Frontend\Project\ProjectDetail;

use App\Models\Project\Project;
use Illuminate\View\Component;
use Illuminate\View\View;
use App\Services\Project\ProjectService;
use Illuminate\Support\Collection;

class RelatedProjects extends Component
{
    protected $projectService;

    public $relatedProjects;
    /**
     * Create the component instance.
     */
    public function __construct(

        public Project $project,

    ) {
        $this->projectService = app(ProjectService::class);
        $this->relatedProjects = $this->getRelatedProjects();
    }

    public function getRelatedProjects(): Collection
    {
        return $this->projectService->getRelatedProjectsByProjectId($this->project->id, 10);
    }

    public function render(): View
    {
        return view('components.frontend.project.project-detail.related-projects');
    }
}
