<?php

namespace App\View\Components\Frontend\Sidebar\Widgets;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;
use App\Services\Blog\PostCategoryService;

class ArticleCategoriesV1 extends Component
{
    public $categories;
    protected $postCategoryService;
    /**
     * Create a new component instance.
     */
    public function __construct()
    {
        $this->postCategoryService =  app(PostCategoryService::class);
        $this->categories = $this->postCategoryService->getAll()->whereHas('posts')->get();
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.frontend.sidebar.widgets.article-categories-v1');
    }
}
