<?php

namespace App\View\Components\Frontend\Sidebar\Widgets;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;
use App\Services\Blog\PostTagService;

class ArticleTagsV1 extends Component
{
    protected $postTagService;
    public $tags;
    /**
     * Create a new component instance.
     */
    public function __construct()
    {
        $this->postTagService = app(PostTagService::class);
        $this->tags = $this->postTagService->getAll()->take(5)->get();
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.frontend.sidebar.widgets.article-tags-v1');
    }
}
