<?php

namespace App\View\Components\Frontend\Sidebar\Widgets;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;
use App\Services\Blog\PostService;

class PopularBlog extends Component
{
    protected $postService;

    public $post;

    public $listType;

    /**
     * Create a new component instance.
     */
    public function __construct(PostService $postService, $post = null, $listType = 'popular')
    {
        $this->postService = $postService;
        $this->post = $post;
        $this->listType = $listType;
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        $blogs = $this->postService->getAll(['status' => 'publish'])->orderBy('created_at', 'desc')->limit(6)->get();
        return view('components.frontend.sidebar.widgets.popular-blog', compact('blogs'));
    }
}
