<?php

namespace App\View\Components\Frontend\Sidebar\Widgets;

use App\Services\User\UserService;
use Illuminate\View\Component;

class ProfileIntro extends Component
{
    public $user;

    public $reviewsStats;

    public $userService;

    public function __construct(UserService $userService, $user = null)
    {
        $this->userService = $userService;
        $this->user = $user;
    }

    public function render()
    {
        $this->reviewsStats = $this->userService->getUserReviewsStats($this->user->id);
        return view('components.frontend.sidebar.widgets.profile-intro');
    }
}
