<?php

namespace App\View\Components\Frontend\Sidebar\Widgets;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;
use App\Services\User\UserService;

class SponsoredListings extends Component
{
    public $userService;

    /**
     * Create a new component instance.
     */
    public function __construct(UserService $userService)
    {
        $this->userService = $userService;
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        $sponsoredListings = $this->userService->getSponsoredListings($limit = 5);
        return view('components.frontend.sidebar.widgets.sponsored-listings', [
            'sponsoredListings' => $sponsoredListings,
        ]);
    }
}
