<?php

namespace App\View\Components\Frontend\Team\Partials;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;
use App\Services\Job\JobService;
use Illuminate\Support\Collection;

class TeamMemeberLatestJobs extends Component
{
    protected $jobService;
    public $latestJobs;

    /**
     * Create a new component instance.
     */
    public function __construct(JobService $jobService,public $userId)
    {
        $this->jobService = $jobService;
        $this->latestJobs = $this->getLatestJobs();
    }

    public function getLatestJobs():Collection
    {
        $args = [
            'user_id' => $this->userId,
            'limit' => 3,
            'order_by' => 'created_at',
            'order' => 'desc',
        ];
        return $this->jobService->getAll($args)->get();
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.frontend.team.partials.team-memeber-latest-jobs');
    }
}
