<?php

namespace App\View\Components\Frontend\Video\Partials;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;
use App\Services\User\UserVideoService;

class FeaturedVideos extends Component
{
    public $userVideoService;
    /** 
     * Create a new component instance.
     */
    public function __construct(UserVideoService $userVideoService)
    {
        $this->userVideoService = $userVideoService;
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        $videos = $this->userVideoService->getFeaturedVideos();
        return view('components.frontend.video.partials.featured-videos', compact('videos'));
    }
}
