<?php

namespace App\View\Components\Frontend\Widgets;

use Illuminate\Contracts\View\View;
use Illuminate\View\Component;
use Illuminate\Support\Facades\Storage;

class CostAQuote extends Component
{
    public array $pageData = [];

    public string $heading;
    public string $description;
    public string $desktop_background_image;
    public string $left_image;
    public string $right_image;
    public string $mobile_background_image;
    public string $button_text;
    public string $button_link;

    public array $component = [];

    public function __construct(array $pageData = [])
    {
        $this->pageData = $pageData;

        $component = $pageData['cost_a_quote'] ?? [];
        $this->component = $component;

        $this->heading = !empty($component['heading'])
            ? $component['heading']
            : 'Get the cost to drill a well';

        $this->description = !empty($component['description'])
            ? $component['description']
            : 'Want the top spot, get featured now.';

        $desktop_bg_img = !empty($component['cost_a_quote_desktop_bg_img'])
            ? $component['cost_a_quote_desktop_bg_img']
            : null;
        $mobile_bg_img = !empty($component['cost_a_quote_mobile_bg_img'])
            ? $component['cost_a_quote_mobile_bg_img']
            : null;

        $this->desktop_background_image = !empty($desktop_bg_img)
            ? Storage::url($desktop_bg_img)
            : asset('images/cost-men-img.png');
        $this->mobile_background_image = !empty($mobile_bg_img)
            ? Storage::url($mobile_bg_img)
            : asset('images/cost-men-img-mobile.png');

        $this->button_text = !empty($component['button_text'])
            ? $component['button_text']
            : 'Get a quote';

        $this->button_link = !empty($component['button_link'])
            ? $component['button_link']
            : '#';

        $this->left_image = !empty($component['cost_a_quote_left_img'])
            ? Storage::url($component['cost_a_quote_left_img'])
            : asset('images/get-cost-left-img.png');
        $this->right_image = !empty($component['cost_a_quote_right_img'])
            ? Storage::url($component['cost_a_quote_right_img'])
            : asset('images/get-cost-right-img.png');
    }

    public function render(): View
    {
        return view('components.frontend.widgets.cost-a-quote');
    }
}
