<?php

namespace App\View\Components\Frontend\Widgets;

use Illuminate\Support\Facades\Storage;
use Illuminate\View\Component;
use Illuminate\Contracts\View\View;
class EstimateBanner extends Component
{
    public $pageData = [];
    public $component = null;
    public $heading;
    public $description;
    public $lead_bg_img;
    public $expertise;


    public function __construct($pageData = null)
    {
        $this->pageData = $pageData ?? [];
        $component = $pageData['estimate_banner'];
        $this->component = $component;
        $this->heading = !empty($this->component['heading']) ? $this->component['heading'] : 'Get an online estimate for the cost to drill a water well';
        $this->description = !empty($this->component['description']) ? $this->component['description'] : 'As the trusted local well drilling contractor, our online system is the straightforward, no-hassle way to get rock-solid, site-specific water well prices. It ensures all necessary details are gathered upfront, saving you time and the frustration of phone tag. Please enter your address to begin.';
        $this->lead_bg_img = !empty($this->component['lead_bg_img']) ? Storage::url($this->component['lead_bg_img']) : asset('images/start-banner-bg.jpg');
        $this->expertise = !empty($this->component['expertise']) ? $this->component['expertise'] : [];
    }

    public function render(): View|string
    {
        return view('components.frontend.widgets.estimate-banner');
    }
}


