<?php

namespace App\View\Components\Frontend\Widgets;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;
use Illuminate\Support\Facades\Storage;

class Faqs extends Component
{
    protected $pageData;
    public $heading;
    public $description;
    public $faqs;
    public $component;
    /**
     * Create a new component instance.
     */
    public function __construct($pageData = null)
    {
        $component = $pageData['faqs'];
        $this->pageData = $pageData;
        $this->heading = !empty($component['heading']) ? $component['heading'] : 'Frequently asked questions';
        $this->description = !empty($component['description']) ? $component['description'] : 'You’ve got questions, we’ve hot answers';
        $this->faqs = !empty($component['faqs']) ? $component['faqs'] : [];  
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.frontend.widgets.faqs');
    }
}
