<?php

namespace App\View\Components\Frontend\Widgets;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;
use Illuminate\Support\Facades\Storage;

class HeroSectionV2 extends Component
{
    protected $page = [];

    public $heading;
    public $search_title;
    public $search_placeholder;
    public $location_title;
    public $location_placeholder;
    public $tabs = [];
    public $popular_searches = [];
    public $banner_image;
    public $banner_image_mobile;
    /**
     * Create a new component instance.
     */
    public function __construct($page = null)
    {
        $this->page = $page;
        $pageData = $page->data;
        $this->heading = !empty($pageData['home_template']['banner_heading']) ? $pageData['home_template']['banner_heading'] : 'Discover and connect <br/> with <i>trusted businesses</i>';
        $this->search_title = !empty($pageData['home_template']['search_title']) ? $pageData['home_template']['search_title'] : 'Water Well Drilling Companies';
        $this->search_placeholder = !empty($pageData['home_template']['search_placeholder']) ? $pageData['home_template']['search_placeholder'] : 'Search by company names';
        $this->location_title = !empty($pageData['home_template']['location_title']) ? $pageData['home_template']['location_title'] : 'Where';
        $this->location_placeholder = !empty($pageData['home_template']['location_placeholder']) ? $pageData['home_template']['location_placeholder'] : 'Search location';
        $this->tabs = !empty($pageData['home_template']['tabs']) ? $pageData['home_template']['tabs'] : [];
        $this->popular_searches = !empty($pageData['home_template']['popular_searches']) ? $pageData['home_template']['popular_searches'] : [];
        $banner_image = !empty($pageData['home_template']['banner_image']) ? $pageData['home_template']['banner_image'] : null;
        $banner_image_mobile = !empty($pageData['home_template']['banner_image_mobile']) ? $pageData['home_template']['banner_image_mobile'] : null;
        $this->banner_image = !empty($banner_image) ? Storage::url($banner_image) : asset('images/home-banner-v3.jpg');
        $this->banner_image_mobile = !empty($banner_image_mobile) ? Storage::url($banner_image_mobile) : asset('images/home-banner-mobile.png');
    }


    public function getTabs()
    {
        $availableTabs = [
            'find_company' => ['label' => __('Find Company')],
            'jobs' => ['label' => __('Jobs')],
            'classifieds' => ['label' => __('Classifieds')],
            'manufactures' => ['label' => __('Manufactures')],
            'suppliers' => ['label' => __('Suppliers')],
        ];


        $orderedTabs = array_values(array_filter($this->tabs ?? [], fn($tab) => array_key_exists($tab, $availableTabs)));
        $defaultTab = $orderedTabs[0] ?? null;
    }

    public function getTabData(): array
    {
        $availableTabs = [
            'find_company' => ['label' => __('Find Company')],
            'jobs' => ['label' => __('Jobs')],
            'classifieds' => ['label' => __('Classifieds')],
            'manufactures' => ['label' => __('Manufactures')],
            'suppliers' => ['label' => __('Suppliers')],
        ];

        $orderedTabs = array_values(array_filter($this->tabs ?? [], fn ($tab) => array_key_exists($tab, $availableTabs)));
        $defaultTab = $orderedTabs[0] ?? null;
        $searchRoutes = [];
        foreach ($orderedTabs as $tab) {
            $searchRoutes[$tab] = $this->getSearchRoute($tab);
        }

        $defaultSearchRoute = $this->getSearchRoute($defaultTab ?? 'find_company');

        return compact('availableTabs', 'orderedTabs', 'defaultTab', 'searchRoutes', 'defaultSearchRoute');
    }

    public function getSearchRoute(string $tab): string
    {
        return match ($tab) {
            'find_company' => route('member.index'),
            'jobs' => route('job.index'),
            'classifieds' => route('classified.index'),
            'manufacturers' => route('member.index'),
            'suppliers' => route('member.index'), 
            default => route('member.index'),
        };
    }

    public function search()
    {
        foreach ($this->tabs as $tab) {
            switch ($tab) {
                case 'find_company':
                    return route('member.index',['q'=>request()->input('q')]);
                case 'jobs':
                    return route('job.index',['q'=>request()->input('q')]);
                case 'classifieds':
                    return route('classified.index',['q'=>request()->input('q')]);
                case 'manufacturers':
                    return route('member.index',['q'=>request()->input('q')]);
                case 'suppliers':
                    return route('member.index',['q'=>request()->input('q')]);
            }
        }
    }
    public function getPopularSearches()
    {
        return $this->popular_searches;
    }
    public function getBannerImage()
    {
        return $this->banner_image;
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.frontend.widgets.hero-section-v2', $this->getTabData());
    }
}
