<?php

namespace App\View\Components\Frontend\Widgets;

use Illuminate\Support\Facades\Storage;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;
class OurPartners extends Component
{

    protected $pageData;
    public string $heading;
    public string $description;
    public array $partners;
    public $partner_desktop_bg_image;
    public $component;

    public function __construct($pageData = [])
    {
        $component= $pageData['our_partners'];
        $this->component = $component;
        $this->heading = !empty($component['heading']) ? $component['heading'] : '<p>Build a business <em>with purpose</em></p>';
        $this->description = !empty($component['description']) ? $component['description'] : "You're in the business of so much more than just the money you make. You value your time, your freedom, your energy, the relationship with your audience, and the impact you have on their lives. We do too.";
        $this->partners = !empty($component['partners']) ? $component['partners'] : [];
        $bg_image = !empty($component['partner_desktop_bg_image']) ? $component['partner_desktop_bg_image'] : null;
        $this->partner_desktop_bg_image = !empty($bg_image) ? Storage::url($bg_image) : asset('images/gradient-bg.png');
    }

    public function render()
    {
        return view('components.frontend.widgets.our-partners');
    }
}
