<?php

namespace App\View\Components\Frontend\Widgets;

use Illuminate\Contracts\View\View;
use Illuminate\View\Component;
use Illuminate\Support\Facades\Storage;


class RequestEstimate extends Component
{
    public array $pageData = [];
    public string $title;
    public string $description;
    public string $desktop_background_image;
    public array $features = [];
    public string $request_estimate_button_text;
    public string $request_estimate_button_link;
    public string $how_work_text;
    public string $how_work_link;
    public string $contractor_name;
    public string $featured_image;
    public string $quick_process_heading;
    public array $quick_process;
    public array $component = [];


    public function __construct(array $pageData = [])
    {
        $this->pageData = $pageData;
        $component = $pageData['request_estimate'] ?? [];
        $this->component = $component;
        $this->title = !empty($component['title'])
            ? $component['title']
            : 'Get the local <em>cost to drill a well</em> online';
        $this->description = !empty($component['description'])
            ? $component['description']
            : 'As your trusted local well drilling contractor, our online estimate system provides straightforward, site specific water well pricing. No hassle, no phone tag-just honest, transparent pricing tailored to your property.';
        $this->desktop_background_image = !empty($component['desktop_background_image'])
            ? Storage::url($component['desktop_background_image'])
            : asset('images/request-cost-gradient-bg.png');
        $this->features = !empty($component['features'])
            ? $component['features']
            : [];
        $this->request_estimate_button_text = !empty($component['request_estimate_button_text'])
            ? $component['request_estimate_button_text']
            : 'Request Your Free Estimate';
        $this->request_estimate_button_link = !empty($component['request_estimate_button_link'])
            ? $component['request_estimate_button_link']
            : '#';
        $this->how_work_text = !empty($component['how_work_text'])
            ? $component['how_work_text']
            : 'How it Works';
        $this->how_work_link = !empty($component['how_work_link'])
            ? $component['how_work_link']
            : '#';
        $this->contractor_name = !empty($component['contractor_name'])
            ? $component['contractor_name']
            : 'Local drilling contractor';
        $this->featured_image = !empty($component['featured_image'])
            ? Storage::url($component['featured_image'])
            : asset('images/contractor-img.png');
        $this->quick_process_heading = !empty($component['quick_process_heading'])
            ? $component['quick_process_heading']
            : '';
        $this->quick_process = !empty($component['quick_process'])
            ? $component['quick_process']
            : [];
    }

    public function render(): View
    {
        return view('components.frontend.widgets.request-estimate');
    }
}
