<?php
namespace App\View\Components\Frontend\Widgets;

use Illuminate\Contracts\View\View;
use Illuminate\View\Component;
use App\Services\User\MemberCategoryService;

class Services extends Component
{
    protected MemberCategoryService $memberCategoryService;

    public array $component = [];
    public int $limit = 12;
    public $categories;
    public string $heading;
    public string $description;

    public function __construct(MemberCategoryService $memberCategoryService, array $pageData = [])
    {
        $this->memberCategoryService = $memberCategoryService;

        $component = $pageData['services'] ?? [];
        $this->component = $component;
        $this->heading = !empty($component['heading']) ? (string) $component['heading'] : '<p>Other <em>Services</em></p>';
        $this->description = !empty($component['description']) ? (string) $component['description'] : 'Want the top spot, get featured now.';
        $this->limit = !empty($component['limit']) ? (int) $component['limit'] : $this->limit;
        $this->getCategories();
    }

    public function getCategories()
    {
        $componentData = $this->component ?? [];

        // 1) Selected categories by IDs: fetch exactly provided IDs
        $selectedIds = $componentData['selectedCategoryIds']
            ?? $componentData['selectedIds']
            ?? $componentData['categories']
            ?? [];
        $selectedIds = array_values(array_filter(array_map('intval', (array) $selectedIds)));

        if (!empty($selectedIds)) {
            $this->categories = $this->memberCategoryService
                ->getAll()
                ->whereIn('member_categories.id', $selectedIds)
                ->get();
            return;
        }

        // 2) Default: limited list
        $args = [
            'limit' => $this->limit,
        ];
        $this->categories = $this->memberCategoryService->getAll($args)->get();
    }

    public function render(): View|string
    {
        return view('components.frontend.widgets.services');
    }
}
