<?php

namespace App\View\Components\TipTap\Blocks;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class ButtonBlock extends Component
{
    /**
     * Create a new component instance.
     */
    public function __construct(
        public ?string $label = null,
        public ?string $color = null,
        public ?string $size = null,
        public ?string $url = null,
        public ?string $target = null,
        public ?string $style = 'solid',
        public ?string $align = 'left',
        public ?string $hovereffect = 'reverse',
    ) {

    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.tip-tap.blocks.button-block');
    }
}
