<?php

namespace App\View\Components\TipTap\Blocks;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Storage;

class ImageAdBlock extends Component
{
    /**
     * Create a new component instance.
     *
     * @param string|null $thumbnaillink The destination URL for the advertisement
     * @param string|null $buttontarget The target attribute for the link (_self or _blank)
     * @param string|null $imageurl The path to the advertisement image
     * @param string|null $alttext The alt text for the image
     * @param string|null $trackingid Optional tracking identifier for analytics
     * @param bool $lazyload Whether to enable lazy loading
     * @param bool $responsive Whether to enable responsive sizing
     */
    public function __construct( 
        public ?string $thumbnaillink = null,
        public ?string $buttontarget = null,
        public ?string $imageurl = null,
        public ?string $alttext = null,
        public ?string $trackingid = null,
        public bool $lazyload = true,
        public bool $responsive = true,
    )
    {
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.tip-tap.blocks.image-ad-block');
    }

    /**
     * Get the cached image URL with a 24-hour cache duration
     */
    public function getImageUrl(): string
    {
        $cacheKey = 'thumbnail-ad-url-' . md5($this->imageurl);
        
        return Cache::remember(
            $cacheKey,
            now()->addHours(24),
            fn () => Storage::url($this->imageurl)
        );
    }
}
