<?php

namespace App\View\Components\TipTap\Blocks;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class ImageWithCaption extends Component
{
    /**
     * Create a new component instance.
     */
    public function __construct(
        public ?string $image = null,
        public ?string $caption = null,
        public ?string $alttext = null,
        public ?string $alignment = 'center',
        public ?string $size = 'medium',
    ) {}

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.tip-tap.blocks.image-with-caption');
    }
} 