<?php
namespace App\View\Composers;

use Illuminate\View\View;

class FooterComposer
{
    public function compose(View $view)
    {
        // dump($view);
        $footerLogo   = get_footer_light_logo();
        $about        = get_app_about();
        $social_links = get_footer_social_links();
        $copyright    = get_footer_copyright();
        $menu_1       = get_footer_menu_1();
        $menu_2 = get_footer_menu_2();
        $subscription = get_footer_subscription();
        $view->with('footerLogo', $footerLogo);
        $view->with('about', $about);
        $view->with('social_links', $social_links);
        $view->with('copyright', $copyright);
        $view->with('menu_1', $menu_1);
        $view->with('menu_2', $menu_2);
        $view->with('subscription', $subscription);
    }
}
