<?php
return [
    'menu_items' => [
        [
            'name' => 'Dashboard',
            'icon' => 'dashboard',
            'route' => 'dashboard',
            'permission' => null,
            'exact' => true,
            'gates' => null,
            'policies' => null,
        ],
        [
            'name' => 'Manage Profile',
            'icon' => 'manage-profile',
            'permission' => null,
            'has_dropdown' => true,
            'gates' => null,
            'submenu' => [
                [
                    'name' => 'Basic Information',
                    'route' => 'dashboard.profile.basic',
                    'permission' => null,
                    'gates' => null,
                ],
                [
                    'name' => 'Profile Photos',
                    'route' => 'dashboard.profile.photo',
                    'permission' => null,
                    'gates' => null,
                ],
                [
                    'name' => 'Gallery Images',
                    'route' => 'dashboard.profile.gallery',
                    'permission' => null,
                    'gates' => [
                        'userGalleryUploadImages',
                    ],
                ],
                [
                    'name' => 'Services',
                    'route' => 'dashboard.profile.service',
                    'permission' => null,
                    'gates' => null,
                ],
                [
                    'name' => 'Location',
                    'route' => 'dashboard.profile.location.index',
                    'permission' => null,
                    'gates' => null,
                    'policies' => [
                        [
                            'model' => 'App\Models\User\UserLocation',
                            'method' => [
                                'viewAny',
                            ],
                        ],
                    ]
                ],
                [
                    'name' => 'Categories',
                    'route' => 'dashboard.profile.category',
                    'permission' => null,
                    'gates' => [
                        'isService',
                    ],
                    'policies' => [
                        [
                            'model' => 'App\Models\User\MemberCategory',
                            'method' => 'viewAny',
                        ],
                    ],
                ],
                [
                    'name' => 'Business Member',
                    'route' => 'dashboard.profile.business-member',
                    'permission' => null,
                    'gates' => [
                        'isMfgSupplier',
                    ],
                    'policies' => [],
                ],
            ],
        ],
        [
            'name' => 'Manage Leads',
            'icon' => 'lead',
            'route' => 'dashboard.manage-lead',
            'permission' => null,
            'exact' => true,
            'gates' => null,
            'policies' => [
                [
                    'model' => 'App\Models\Lead\Lead',
                    'method' => 'viewAny',
                ],
            ],
        ],
        [
            'name' => 'Classified Ads',
            'icon' => 'classified',
            'route' => 'dashboard.classified',
            'permission' => null,
            'exact' => true,
            'gates' => null,
            'policies' => [
                [
                    'model' => 'App\Models\Classified\Classified',
                    'method' => 'viewAny',
                ],
            ],
        ],
        [
            'name' => 'Jobs',
            'icon' => 'job',
            'permission' => null,
            'has_dropdown' => true,
            'exact' => true,
            'gates' => null,
            'policies' => [
                [
                    'model' => 'App\Models\Job\Job',
                    'method' => 'viewAny',
                ],
            ],
            'submenu' => [
                [
                    'name' => 'All Jobs',
                    'route' => 'dashboard.job',
                    'permission' => null,
                    'gates' => null,
                    'policies' => [
                        [
                            'model' => 'App\Models\Job\Job',
                            'method' => 'viewAny',
                        ],
                    ],
                ],
                [
                    'name' => 'Add New Job',
                    'route' => 'dashboard.job.add',
                    'permission' => null,
                    'gates' => null,
                    'policies' => [
                        [
                            'model' => 'App\Models\Job\Job',
                            'method' => 'create',
                        ],
                    ],
                ],
                [
                    'name' => 'All Job Applications',
                    'route' => 'dashboard.job.application',
                    'permission' => null,
                    'gates' => null,
                    'policies' => [
                        [
                            'model' => 'App\Models\Job\JobApplication',
                            'method' => 'viewAny',
                        ],
                    ],
                ],
            ],
        ],

        [
            'name' => 'Articles',
            'icon' => 'article',
            'route' => 'dashboard.article',
            'permission' => null,
            'exact' => false,
            'gates' => null,
            'policies' => [
                [
                    'model' => 'App\Models\Blog\Post',
                    'method' => 'viewAny',
                ],
            ],
        ],
        [
            'name' => 'Projects',
            'icon' => 'project',
            'route' => 'dashboard.project',
            'permission' => null,
            'exact' => true,
            'gates' => null,
            'policies' => [
                [
                    'model' => 'App\Models\Project\Project',
                    'method' => 'viewAny',
                ],
            ],
        ],
        [
            'name' => 'Teams',
            'icon' => 'team',
            'route' => 'dashboard.team',
            'permission' => null,
            'exact' => true,
            'gates' => null,
            'policies' => [
                [
                    'model' => 'App\Models\Team\TeamMember',
                    'method' => 'viewAny',
                ],
            ],
        ],
        [
            'name' => 'Equipment',
            'icon' => 'article',
            'permission' => null,
            'exact' => true,
            'has_dropdown' => true,
            'gates' => null,
            'submenu' => [
                [
                    'name' => 'All Equipment',
                    'route' => 'dashboard.equipments',
                    'permission' => null,
                    'gates' => null,
                    'policies' => [
                        [
                            'model' => 'App\Models\Equipment\Equipment',
                            'method' => 'viewAny',
                        ],
                    ],
                ],
                [
                    'name' => 'Add New Equipment',
                    'route' => 'dashboard.equipments.create',
                    'permission' => null,
                    'gates' => null,
                    'policies' => [
                        [
                            'model' => 'App\Models\Equipment\Equipment',
                            'method' => 'create',
                        ],
                    ],
                ],
            ],
        ],
        [
            'name' => 'Videos',
            'icon' => 'video',
            'route' => 'dashboard.video',
            'permission' => null,
            'exact' => true,
            'gates' => null,
            'policies' => [
                [
                    'model' => 'App\Models\User\UserVideo',
                    'method' => 'viewAny',
                ],
            ],
        ],
        [
            'name' => 'Products',
            'icon' => 'product',
            'route' => 'dashboard.product',
            'permission' => null,
            'exact' => true,
            'gates' => null,
            'policies' => [
                [
                    'model' => 'App\Models\Product\Product',
                    'method' => 'viewAny',
                ],
            ],
        ],
        [
            'name' => 'Manufacturer & Suppliers',
            'icon' => 'manufacturers-supplier',
            'route' => 'dashboard.manufacturers-supplier',
            'permission' => null,
            'exact' => true,
            'gates' => [
                'isService'
            ],
            'policies' => [
                [
                    'model' => 'App\Models\User\MemberCategory',
                    'method' => 'viewAny',
                ],
            ],
        ],
        [
            'name' => 'Reviews',
            'icon' => 'review',
            'route' => 'dashboard.review',
            'permission' => null,
            'exact' => true,
            'gates' => null,
            'policies' => [
                [
                    'model' => 'App\Models\Review',
                    'method' => 'viewAny',
                ],
            ],
        ],
        [
            'name' => 'Favourites',
            'icon' => 'bookmark',
            'route' => 'dashboard.favourite',
            'permission' => null,
            'exact' => true,
            'gates' => null,
            'policies' => null,
        ],
        [
            'name' => 'Account & Subscription',
            'icon' => 'account-subscription',
            'route' => 'dashboard.account-subscription',
            'permission' => null,
            'exact' => true,
            'gates' => [
                'account&Subscription'
            ],
        ],
        [
            'name' => 'Inquiries',
            'icon' => 'lead-inquire',
            'route' => 'dashboard.lead-inquirie',
            'permission' => null,
            'exact' => true,
            'gates' => null,
            'policies' => [
                [
                    'model' => 'App\Models\User\Inquiry',
                    'method' => 'viewAny',
                ],
            ],
        ],
    ],
];
