<?php

return [
    'models' => [
        'Page' => 'App\\Models\\Page',
        'BlogPost' => 'App\\Models\\Blog\\Post',
    ],
    'api_enabled' => true,
    'cache' => [
        'enabled' => true,
        'key' => 'filament-menu-builder',
        'ttl' => 60 * 60 * 24,
    ],
    'usable_parameters' => [
        // For example:
        // 'mega_menu',
        // 'mega_menu_columns',
    ],
    'exclude_route_names' => [
        '/^debugbar\./', // Exclude debugbar routes
        '/^filament\./',   // Exclude filament routes
        '/^livewire\./',   // Exclude livewire routes
        '/^dashboard\./',
    ],
    'exclude_routes' => [
        'dashboard.',
    ],
    'dto' => [
        'menu' => \Biostate\FilamentMenuBuilder\DTO\Menu::class,
        'menu_item' => \Biostate\FilamentMenuBuilder\DTO\MenuItem::class,
    ],
];
