<?php

return [
    'sections' => [
        'availability' => [
            'label' => 'When are you available to start?',
            'required' => true,
            'type' => 'radio_group',
            'options' => [
                'right_away' => [
                    'label' => 'Right away',
                    'icon' => 'flash-small'
                ],
                'one_month' => [
                    'label' => 'One month after offer',
                    'icon' => 'time-one'
                ],
                'specific_date' => [
                    'label' => 'After a specific date',
                    'icon' => 'calendar-close',
                    'has_conditional' => true
                ]
            ],
            'conditional_field' => [
                'name' => 'availability_date',
                'type' => 'date',
                'condition' => 'specific_date',
                'validation' => 'nullable|date|after:today'
            ],
            'validation' => 'required|in:right_away,one_month,specific_date'
        ],

        'video_introduction' => [
            'label' => 'Add video introduction',
            'description' => 'We only allow either a loom recording or a video hosted on youtube.',
            'required' => false,
            'type' => 'platform_selector',
            'platforms' => [
                'youtube' => [
                    'label' => 'Youtube',
                    'url_field' => [
                        'name' => 'youtube_url',
                        'prefix' => 'Link',
                        'placeholder' => 'https://www.youtube.com/example',
                        'help_text' => 'How to upload a video?'
                    ]
                ],
                'loom' => [
                    'label' => 'Loom',
                    'url_field' => [
                        'name' => 'loom_url',
                        'prefix' => 'Link',
                        'placeholder' => 'https://www.loom.com/example',
                        'help_text' => 'How to upload a video?'
                    ]
                ]
            ],
            'validation' => [
                'video_platform' => 'nullable|in:youtube,loom',
                'youtube_url' => 'nullable|required_if:video_platform,youtube|url|regex:/^https:\/\/(www\.)?youtube\.com\//',
                'loom_url' => 'nullable|required_if:video_platform,loom|url|regex:/^https:\/\/(www\.)?loom\.com\//'
            ]
        ],

        'legal_authorization' => [
            'label' => 'Are you legally authorized in the country where the job is located?',
            'required' => true,
            'type' => 'radio',
            'options' => [
                'yes' => 'Yes',
                'no' => 'No'
            ],
            'validation' => 'required|in:yes,no'
        ],

        'visa_sponsorship' => [
            'label' => 'Will you now or in the future require visa sponsorship to work in the country where the job is located?',
            'required' => true,
            'type' => 'radio',
            'options' => [
                'yes' => 'Yes',
                'no' => 'No'
            ],
            'validation' => 'required|in:yes,no'
        ],

        'resume' => [
            'label' => 'Upload your CV/Resume?',
            'required' => true,
            'type' => 'file',
            'accept' => 'application/pdf',
            'max_size' => 10240, // 10MB in KB
            'collection' => 'resume',
            'description' => 'Attach up to 1 file, max 10 MB, PDF\'s only.',
            'validation' => 'required|mimes:pdf|max:10240'
        ],

        'relevant_experience' => [
            'label' => 'Can you share your relevant experience?',
            'required' => false,
            'type' => 'rich_text',
            'editor_config' => [
                'toolbar' => [
                    ['bold', 'italic', 'underline'],
                    ['size' => ['10px', '12px', '14px', '16px', '18px', '24px', '32px']],
                    ['align' => []],
                    ['list' => 'ordered', 'list' => 'bullet', 'link']
                ],
                'theme' => 'snow',
                'placeholder' => 'Describe your relevant experience...'
            ],
            'validation' => 'nullable|string|max:2000'
        ],

        'additional_info_1' => [
            'label' => 'Is there anything that we should know about you?',
            'required' => false,
            'type' => 'rich_text',
            'editor_config' => [
                'toolbar' => [
                    ['bold', 'italic', 'underline'],
                    ['size' => ['10px', '12px', '14px', '16px', '18px', '24px', '32px']],
                    ['align' => []],
                    ['list' => 'ordered', 'list' => 'bullet', 'link']
                ],
                'theme' => 'snow',
                'placeholder' => 'Tell us anything else we should know...'
            ],
            'validation' => 'nullable|string|max:2000'
        ],

        'additional_info_2' => [
            'label' => 'Is there anything that we should know about you?',
            'required' => false,
            'type' => 'rich_text',
            'editor_config' => [
                'toolbar' => [
                    ['bold', 'italic', 'underline'],
                    ['size' => ['10px', '12px', '14px', '16px', '18px', '24px', '32px']],
                    ['align' => []],
                    ['list' => 'ordered', 'list' => 'bullet', 'link']
                ],
                'theme' => 'snow',
                'placeholder' => 'Any additional information...'
            ],
            'validation' => 'nullable|string|max:2000'
        ]
    ],

    'layout' => [
        'left_column' => [
            'availability',
            'video_introduction',
            'legal_authorization',
            'visa_sponsorship',
            'resume'
        ],
        'right_column' => [
            'relevant_experience',
            'additional_info_1',
            'additional_info_2'
        ]
    ],

    'validation_messages' => [
        'availability.required' => 'Please select when you are available to start.',
        'availability.in' => 'Please select a valid availability option.',
        'availability_date.required_if' => 'Please select a specific date.',
        'availability_date.after' => 'Availability date must be in the future.',
        'video_platform.in' => 'Please select either YouTube or Loom.',
        'youtube_url.required_if' => 'Please enter a valid YouTube URL.',
        'youtube_url.url' => 'Please enter a valid YouTube URL.',
        'youtube_url.regex' => 'Please enter a valid YouTube URL.',
        'loom_url.required_if' => 'Please enter a valid Loom URL.',
        'loom_url.url' => 'Please enter a valid Loom URL.',
        'loom_url.regex' => 'Please enter a valid Loom URL.',
        'legal_authorization.required' => 'Please indicate if you are legally authorized to work.',
        'legal_authorization.in' => 'Please select Yes or No for legal authorization.',
        'visa_sponsorship.required' => 'Please indicate if you require visa sponsorship.',
        'visa_sponsorship.in' => 'Please select Yes or No for visa sponsorship.',
        'resume.required' => 'Please upload your resume.',
        'resume.mimes' => 'Resume must be a PDF file.',
        'resume.max' => 'Resume file size must not exceed 10MB.',
        'relevant_experience.max' => 'Experience description must not exceed 2000 characters.',
        'additional_info_1.max' => 'Additional information must not exceed 2000 characters.',
        'additional_info_2.max' => 'Additional information must not exceed 2000 characters.'
    ]
];
