<?php

return [
    /*
    |--------------------------------------------------------------------------
    | reCAPTCHA Version
    |--------------------------------------------------------------------------
    |
    | The default reCAPTCHA version to use throughout your application.
    | Supported: "v2", "v3", false (to disable)
    |
    */
    'default' => env('RECAPTCHA_VERSION', 'v3'),

    /*
    |--------------------------------------------------------------------------
    | reCAPTCHA v3 Configuration
    |--------------------------------------------------------------------------
    |
    | Your reCAPTCHA v3 site key and secret key from Google reCAPTCHA admin.
    | Get them from: https://www.google.com/recaptcha/admin
    |
    */
    'site_key_v3' => env('RECAPTCHAV3_SITEKEY'),
    'secret_key_v3' => env('RECAPTCHAV3_SECRET'),

    /*
    |--------------------------------------------------------------------------
    | reCAPTCHA v2 Configuration
    |--------------------------------------------------------------------------
    |
    | Your reCAPTCHA v2 site key and secret key. If not set, v3 keys will be used.
    |
    */
    'site_key_v2' => env('RECAPTCHAV2_SITEKEY', env('RECAPTCHAV3_SITEKEY')),
    'secret_key_v2' => env('RECAPTCHAV2_SECRET', env('RECAPTCHAV3_SECRET')),

    /*
    |--------------------------------------------------------------------------
    | Score Threshold (v3 only)
    |--------------------------------------------------------------------------
    |
    | The minimum score required for reCAPTCHA v3 to pass validation.
    | Range: 0.0 (likely bot) to 1.0 (likely human). Default: 0.5
    |
    */
    'score_threshold' => env('RECAPTCHA_SCORE_THRESHOLD', 0.3),


    /*
    |--------------------------------------------------------------------------
    | Testing Mode
    |--------------------------------------------------------------------------
    |
    | When enabled, reCAPTCHA validation will be bypassed during testing.
    |
    */
    'skip_testing' => env('RECAPTCHA_SKIP_TESTING', env('APP_ENV') === 'testing'),

    /*
    |--------------------------------------------------------------------------
    | Development Mode
    |--------------------------------------------------------------------------
    |
    | When enabled in local environment, reCAPTCHA validation will always pass.
    |
    */
    'fake_in_development' => env('RECAPTCHA_FAKE_DEVELOPMENT', false),

    /*
    |--------------------------------------------------------------------------
    | API Configuration
    |--------------------------------------------------------------------------
    |
    | reCAPTCHA API endpoint and timeout settings.
    |
    */
    'api_url' => 'https://www.google.com/recaptcha/api/siteverify',
    'timeout' => 30,

    /*
    |--------------------------------------------------------------------------
    | Error Messages
    |--------------------------------------------------------------------------
    |
    | Default error messages for validation failures.
    |
    */
    'error_messages' => [
        'required' => 'Please complete the reCAPTCHA verification.',
        'invalid' => 'reCAPTCHA verification failed. Please try again.',
        'score_too_low' => 'reCAPTCHA score too low. Please try again.',
        'expired' => 'reCAPTCHA verification expired. Please refresh and try again.',
        'network_error' => 'Unable to verify reCAPTCHA. Please try again.',
    ],

    /*
    |--------------------------------------------------------------------------
    | Badge Configuration (v3 only)
    |--------------------------------------------------------------------------
    |
    | Configure the reCAPTCHA v3 badge appearance.
    |
    */
    'badge' => [
        'hide' => env('RECAPTCHA_HIDE_BADGE', false),
        'position' => env('RECAPTCHA_BADGE_POSITION', 'bottomright'), // bottomright, bottomleft, inline
    ],

    /*
    |--------------------------------------------------------------------------
    | Widget Configuration (v2 only)
    |--------------------------------------------------------------------------
    |
    | Configure the reCAPTCHA v2 widget appearance.
    |
    */
    'widget' => [
        'theme' => env('RECAPTCHA_V2_THEME', 'light'), // light, dark
        'size' => env('RECAPTCHA_V2_SIZE', 'normal'), // normal, compact
        'type' => env('RECAPTCHA_V2_TYPE', 'image'), // image, audio
        'invisible' => env('RECAPTCHA_V2_INVISIBLE', false),
    ],

    /*
    |--------------------------------------------------------------------------
    | Cloudflare Turnstile Support (Future)
    |--------------------------------------------------------------------------
    |
    | Configuration for Cloudflare Turnstile integration (to be implemented).
    |
    */
    'cloudflare' => [
        'enabled' => env('TURNSTILE_ENABLED', false),
        'site_key' => env('TURNSTILE_SITE_KEY'),
        'secret_key' => env('TURNSTILE_SECRET_KEY'),
        'api_url' => 'https://challenges.cloudflare.com/turnstile/v0/siteverify',
    ],
];
