<?php

namespace Database\Factories\Blog;

use App\Enums\PostStatus;
use App\Models\Blog\Post;
use App\Models\User\User;
use Illuminate\Database\Eloquent\Factories\Factory;

class PostFactory extends Factory
{
    protected $model = Post::class;

    public function definition(): array
    {
        return [
            'post_title' => $this->faker->sentence(),
            'post_description' => $this->faker->paragraphs(3, true),
            'post_status' => $this->faker->randomElement(PostStatus::cases()),
            'is_featured' => $this->faker->boolean(),
            'created_by' => User::factory(),
        ];
    }

    public function published(): static
    {
        return $this->state(fn (array $attributes) => [
            'post_status' => PostStatus::Published,
        ]);
    }

    public function draft(): static
    {
        return $this->state(fn (array $attributes) => [
            'post_status' => PostStatus::Draft,
        ]);
    }
} 