<?php

namespace Database\Factories\Blog;

use App\Models\Blog\PostTag;
use App\Models\User\User;
use Illuminate\Database\Eloquent\Factories\Factory;

class PostTagFactory extends Factory
{
    protected $model = PostTag::class;

    public function definition(): array
    {
        return [
            'name' => $this->faker->unique()->words(2, true),
            'description' => $this->faker->sentence(),
            'created_by' => User::factory(),
        ];
    }
} 