<?php

namespace Database\Factories\Classified;

use App\Models\Classified\ClassifiedCategory;
use App\Models\User\User;
use Illuminate\Database\Eloquent\Factories\Factory;

class ClassifiedCategoryFactory extends Factory
{
    protected $model = ClassifiedCategory::class;

    public function definition(): array
    {
        return [
            'classified_category_name' => $this->faker->unique()->words(2, true),
            'classified_category_description' => $this->faker->sentence(),
            'is_active' => $this->faker->boolean(80), // 80% chance of being active
            'created_by' => User::factory(),
        ];
    }

    public function active(): static
    {
        return $this->state(fn (array $attributes) => [
            'is_active' => true,
        ]);
    }
} 