<?php

namespace Database\Factories\Classified;

use App\Models\Classified\ClassifiedDelivery;
use App\Models\User\User;
use Illuminate\Database\Eloquent\Factories\Factory;

class ClassifiedDeliveryFactory extends Factory
{
    protected $model = ClassifiedDelivery::class;

    public function definition(): array
    {
        $deliveryTypes = [
            'Local Delivery',
            'Same Day Delivery',
            'Next Day Delivery',
            'Standard Delivery',
            'Express Delivery',
            'International Shipping',
            'Pick Up Only',
            'Free Shipping',
            'Overnight Shipping',
            'Weekend Delivery',
            'Business Days Only',
            'Contactless Delivery',
        ];

        return [
            'name' => $this->faker->randomElement($deliveryTypes),
            'description' => $this->faker->sentence(8),
            'is_active' => $this->faker->boolean(85), // 85% chance of being active
            'parent_id' => null, // Can be overridden to create hierarchical structure
            'created_by' => User::inRandomOrder()->first()?->id,
        ];
    }

    public function active(): static
    {
        return $this->state(fn(array $attributes) => [
            'is_active' => true,
        ]);
    }

    public function inactive(): static
    {
        return $this->state(fn(array $attributes) => [
            'is_active' => false,
        ]);
    }

    public function withParent(ClassifiedDelivery $parent): static
    {
        return $this->state(fn(array $attributes) => [
            'parent_id' => $parent->id,
        ]);
    }
}
