<?php

namespace Database\Factories\Classified;

use App\Models\Classified\ClassifiedTag;
use App\Models\User\User;
use Illuminate\Database\Eloquent\Factories\Factory;

class ClassifiedTagFactory extends Factory
{
    protected $model = ClassifiedTag::class;

    public function definition(): array
    {
        return [
            'classified_tag_name' => $this->faker->unique()->words(2, true),
            'is_active' => $this->faker->boolean(80), // 80% chance of being active
            'created_by' => User::factory(),
        ];
    }

    public function active(): static
    {
        return $this->state(fn (array $attributes) => [
            'is_active' => true,
        ]);
    }
} 