<?php

namespace Database\Factories\Classified;

use App\Models\Classified\ClassifiedType;
use App\Models\User\User;
use Illuminate\Database\Eloquent\Factories\Factory;

class ClassifiedTypeFactory extends Factory
{
    protected $model = ClassifiedType::class;

    public function definition(): array
    {
        return [
            'classified_type_name' => $this->faker->unique()->words(2, true),
            'classified_type_description' => $this->faker->sentence(),
            'is_active' => $this->faker->boolean(80), // 80% chance of being active
            'created_by' => User::factory(),
        ];
    }

    public function active(): static
    {
        return $this->state(fn (array $attributes) => [
            'is_active' => true,
        ]);
    }
} 