<?php

namespace Database\Factories;

use App\Models\Currency;
use App\Models\User\User;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

class CurrencyFactory extends Factory
{
    protected $model = Currency::class;

    public static $currencies = [
        ['name' => 'US Dollar', 'code' => 'USD', 'symbol' => '$', 'rate' => 1.00],
        ['name' => 'Euro', 'code' => 'EUR', 'symbol' => '€', 'rate' => 0.85],
        ['name' => 'British Pound', 'code' => 'GBP', 'symbol' => '£', 'rate' => 0.73],
        // Add more currencies as needed
    ];

    public function definition(): array
    {
        $currency = $this->faker->unique()->randomElement(static::$currencies);
        
        return [
            'uuid' => Str::uuid(),
            'currency_name' => $currency['name'],
            'currency_code' => $currency['code'],
            'currency_symbol' => $currency['symbol'],
            'currency_rate' => $currency['rate'],
            'is_active' => $this->faker->boolean(90), // 90% chance of being active
            'is_default' => false,
            'created_by' => User::factory()
        ];
    }

    /**
     * Indicate that the currency is active.
     */
    public function active(): static
    {
        return $this->state(function () {
            return [
                'is_active' => true,
            ];
        });
    }

    /**
     * Indicate that the currency is inactive.
     */
    public function inactive(): static
    {
        return $this->state(function () {
            return [
                'is_active' => false,
            ];
        });
    }

    /**
     * Indicate that the currency is the default.
     */
    public function default(): static
    {
        return $this->state(function () {
            return [
                'is_default' => true,
                'is_active' => true,
            ];
        });
    }
} 