<?php

namespace Database\Factories\Equipment;

use Illuminate\Database\Eloquent\Factories\Factory;
use App\Models\User\User;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Equipment\EquipmentCategory>
 */
class EquipmentCategoryFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        // Get a random existing user
        $user = User::inRandomOrder()->first();
        
        // Fallback to create a user if none exist
        if (!$user) {
            $user = User::factory()->create();
        }

        return [
            'uuid' => $this->faker->uuid(),
            'category_name' => $this->faker->words(2, true),
            'slug' => $this->faker->slug(),
            'category_description' => $this->faker->paragraph(3, true),
            'is_active' => $this->faker->boolean(),
            'created_by' => $user->id,
        ];
    }
}
