<?php

namespace Database\Factories\Equipment;

use Illuminate\Database\Eloquent\Factories\Factory;
use App\Models\Equipment\EquipmentCategory;
use App\Models\User\User;
use App\Models\Location\City;
use App\Models\Location\State;
use App\Models\Location\Country;
use App\Enums\EquipmentStatus;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Equipment\Equipment>
 */
class EquipmentFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        // Get Canada and its locations
        $country = Country::where('country_code', 'CA')->first();
        $state = $country ? State::where('country_id', $country->id)->inRandomOrder()->first() : null;
        $city = $state ? City::where('state_id', $state->id)->inRandomOrder()->first() : null;

        // Get a random existing user
        $user = User::inRandomOrder()->first();

        // Fallback to create a user if none exist
        if (!$user) {
            $user = User::factory()->create();
        }

        return [
            'user_id' => $user->id,
            'title' => $this->faker->sentence(),
            'description' => $this->faker->paragraph(3, true),
            'status' => $this->faker->randomElement(EquipmentStatus::cases()),
            'address' => $this->faker->streetAddress(),
            'city_id' => $city?->id,
            'state_id' => $state?->id,
            'country_id' => $country?->id,
            'tags' => $this->faker->words(5),
            'created_by' => $user->id,
        ];
    }
}
