<?php

namespace Database\Factories\Job;

use App\Models\Job\JobApplication;
use App\Models\Job\Job;
use App\Models\User\User;
use App\Enums\JobApplicationStatus;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

class JobApplicationFactory extends Factory
{
    protected $model = JobApplication::class;

    public function definition(): array
    {
        return [
            'uuid' => Str::uuid(),
            'job_id' => Job::factory(),
            'applicant_id' => User::factory(),
            'application_status' => $this->faker->randomElement(JobApplicationStatus::cases())
        ];
    }
} 