<?php

namespace Database\Factories\Job;

use App\Models\Job\JobCareerLevel;
use App\Models\User\User;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

class JobCareerLevelFactory extends Factory
{
    protected $model = JobCareerLevel::class;

    protected static array $levels = [
        'Entry Level', 'Junior', 'Mid-Level', 'Senior',
        'Lead', 'Manager', 'Director', 'Executive'
    ];

    public function definition(): array
    {
        $name = $this->faker->unique()->randomElement(static::$levels);
        return [
            'uuid' => Str::uuid(),
            'career_level_name' => $name,
            'career_level_description' => $this->faker->paragraph(),
            'slug' => Str::slug($name),
            'is_active' => $this->faker->boolean(80),
            'created_by' => User::factory()
        ];
    }
} 