<?php

namespace Database\Factories\Job;

use App\Models\Job\JobIndustry;
use App\Models\User\User;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

class JobIndustryFactory extends Factory
{
    protected $model = JobIndustry::class;

    protected static array $industries = [
        'Technology', 'Healthcare', 'Finance', 'Education',
        'Manufacturing', 'Retail', 'Construction', 'Media',
        'Transportation', 'Energy', 'Agriculture', 'Real Estate',
        'Hospitality', 'Telecommunications', 'Consulting'
    ];

    public function definition(): array
    {
        $name = $this->faker->unique()->randomElement(static::$industries);
        return [
            'uuid' => Str::uuid(),
            'industry_name' => $name,
            'slug' => Str::slug($name),
            'industry_description' => $this->faker->paragraph(),
            'is_active' => $this->faker->boolean(80),
            'created_by' => User::factory()
        ];
    }
} 