<?php

namespace Database\Factories\Job;

use App\Models\Job\JobSkill;
use App\Models\User\User;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

class JobSkillFactory extends Factory
{
    protected $model = JobSkill::class;

    protected static array $skills = [
        'PHP', 'JavaScript', 'Python', 'Java', 'SQL',
        'Project Management', 'Communication', 'Leadership',
        'Problem Solving', 'Analytics', 'Marketing', 'Sales',
        'Customer Service', 'Design', 'Research', 'Writing',
        'Public Speaking', 'Team Management', 'Budgeting', 'Strategy'
    ];

    public function definition(): array
    {
        $name = $this->faker->unique()->randomElement(static::$skills);
        return [
            'uuid' => Str::uuid(),
            'job_skill_name' => $name,
            'job_skill_description' => $this->faker->paragraph(),
            'slug' => Str::slug($name),
            'is_active' => $this->faker->boolean(80),
            'created_by' => User::factory()
        ];
    }
} 