<?php

namespace Database\Factories\Job;

use App\Models\Job\JobType;
use App\Models\User\User;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

class JobTypeFactory extends Factory
{
    protected $model = JobType::class;

    protected static array $types = [
        'Full-time', 'Part-time', 'Contract', 
        'Temporary', 'Internship'
    ];

    public function definition(): array
    {
        $name = $this->faker->unique()->randomElement(static::$types);
        return [
            'uuid' => Str::uuid(),
            'job_type_name' => $name,
            'job_type_description' => $this->faker->paragraph(),
            'slug' => Str::slug($name),
            'is_active' => $this->faker->boolean(80),
            'created_by' => User::factory()
        ];
    }
} 