<?php

namespace Database\Factories\Lead;

use App\Enums\LeadStatus;
use App\Models\Lead\Lead;
use App\Models\Lead\LeadForm;
use App\Models\User\User;
use Illuminate\Database\Eloquent\Factories\Factory;

class LeadFactory extends Factory
{
    protected $model = Lead::class;

    public function definition(): array
    {
        return [
            'uuid' => fake()->uuid(),
            'lead_form_id' => LeadForm::factory(),
            'first_name' => fake()->firstName(),
            'last_name' => fake()->lastName(),
            'email' => fake()->safeEmail(),
            'phone' => fake()->phoneNumber(),
            'message' => fake()->paragraph(),
            'ip_address' => fake()->ipv4(),
            'lead_status' => fake()->randomElement(LeadStatus::cases()),
            'lead_data' => [
                ['key' => 'address', 'value' => fake()->address()],
                ['key' => 'city', 'value' => fake()->city()],
                ['key' => 'company', 'value' => fake()->optional()->company()],
                ['key' => 'website', 'value' => fake()->optional()->url()],
                ['key' => 'water_well_use', 'value' => fake()->randomElement(['Domestic / Residential', 'Business', 'Agriculture', 'Other'])],
                ['key' => 'existing_well', 'value' => fake()->randomElement(['Yes... a producing well', 'No', 'Yes... but the well has gone dry & or is not producing enough water'])],
                ['key' => 'purchasing_property', 'value' => fake()->randomElement(['Yes', 'No, we are the current registered owners of the property.'])],
                ['key' => 'drilling_new_construction', 'value' => fake()->randomElement(['Yes', 'No', 'Other'])],
                ['key' => 'expected_drilling_date', 'value' => fake()->sentence(3)],
                ['key' => 'estimated_gpm_required', 'value' => fake()->numberBetween(5, 100) . ' GPM'],
                ['key' => 'drilling_site_chosen', 'value' => fake()->sentence(4)],
                ['key' => 'drilled_before', 'value' => fake()->sentence(3)],
                ['key' => 'well_pump_estimate', 'value' => fake()->randomElement(['Yes', 'No'])],
                ['key' => 'additional_information', 'value' => fake()->optional()->paragraph()],
                ['key' => 'voice_message', 'value' => fake()->optional()->randomElement([
                    'voice_message_' . fake()->uuid() . '.mp3',
                    'voice_message_' . fake()->uuid() . '.wav'
                ])],
                ['key' => 'uploaded_files', 'value' => fake()->optional()->randomElements([
                    'site_map_' . fake()->uuid() . '.pdf',
                    'well_log_' . fake()->uuid() . '.pdf',
                    'site_photo_' . fake()->uuid() . '.jpg',
                    'property_map_' . fake()->uuid() . '.png'
                ], fake()->numberBetween(0, 4))],
            ],
            'lead_source' => fake()->url(),
            'created_by' => User::factory(),
        ];
    }
} 
