<?php

namespace Database\Factories\Lead;

use App\Models\Lead\LeadForm;
use App\Models\User\User;
use App\Enums\LeadFormMatchCriteria;
use App\Enums\LeadFormReceptionMode;
use Illuminate\Database\Eloquent\Factories\Factory;

class LeadFormFactory extends Factory
{
    protected $model = LeadForm::class;

    public function definition(): array
    {
        return [
            'uuid' => fake()->uuid(),
            'title' => fake()->sentence(3),
            'description' => fake()->paragraph(),
            'match_criteria' => fake()->randomElement(LeadFormMatchCriteria::cases()),
            'reception_mode' => fake()->randomElement(LeadFormReceptionMode::cases()),
            'enable_captcha' => fake()->boolean(),
            'is_active' => fake()->boolean(80), // 80% chance of being active
            'submit_message' => fake()->sentence(),
            'created_by' => User::factory(),
        ];
    }

    public function active(): static
    {
        return $this->state(fn (array $attributes) => [
            'is_active' => true,
        ]);
    }

    public function inactive(): static
    {
        return $this->state(fn (array $attributes) => [
            'is_active' => false,
        ]);
    }
} 