<?php

namespace Database\Factories\Lead;

use App\Models\Lead\LeadFormFields;
use App\Models\Lead\LeadForm;
use App\Models\User\User;
use App\Enums\LeadFormFieldDataType;
use Illuminate\Database\Eloquent\Factories\Factory;

class LeadFormFieldsFactory extends Factory
{
    protected $model = LeadFormFields::class;

    public function definition(): array
    {
        $dataType = fake()->randomElement(LeadFormFieldDataType::cases());
        $fieldOptions = null;

        // Generate field options for certain field types
        if (in_array($dataType, [LeadFormFieldDataType::AlphaNumeric])) {
            $fieldOptions = json_encode(fake()->words(random_int(3, 6)));
        }

        return [
            'lead_form_id' => LeadForm::factory(),
            'field_name' => fake()->words(2, true),
            'field_placeholder' => fake()->sentence(3),
            'field_id' => 'field_' . fake()->unique()->word(),
            'field_type' => 'text', // Default field type
            'data_type' => $dataType,
            'is_default' => fake()->boolean(90),
            'is_visible' => fake()->boolean(90), // 90% chance of being visible
            'created_by' => User::factory(),
        ];
    }

    public function required(): static
    {
        return $this->state(fn (array $attributes) => [
            'is_required' => true,
        ]);
    }

    public function optional(): static
    {
        return $this->state(fn (array $attributes) => [
            'is_required' => false,
        ]);
    }

    public function visible(): static
    {
        return $this->state(fn (array $attributes) => [
            'is_visible' => true,
        ]);
    }

    public function hidden(): static
    {
        return $this->state(fn (array $attributes) => [
            'is_visible' => false,
        ]);
    }
} 