<?php

namespace Database\Factories\Lead;

use App\Models\Lead\LeadForm;
use App\Models\Lead\LeadFormVisit;
use Illuminate\Database\Eloquent\Factories\Factory;

class LeadFormVisitFactory extends Factory
{
    protected $model = LeadFormVisit::class;

    public function definition(): array
    {
        return [
            'source' => $this->faker->randomElement(['direct', 'google', 'facebook', 'linkedin', 'twitter']),
            'lead_form_id' => LeadForm::factory(),
            'unique_identifier' => $this->faker->uuid(),
            'ip_address' => $this->faker->ipv4(),
            'country' => $this->faker->country(),
            'state' => $this->faker->state(),
            'city' => $this->faker->city(),
            'visit_date' => $this->faker->dateTimeBetween('-3 months', 'now'),
        ];
    }
} 