<?php

namespace Database\Factories\Location;

use App\Models\Location\City;
use App\Models\User\User;
use Illuminate\Database\Eloquent\Factories\Factory;

class CityFactory extends Factory
{
    protected $model = City::class;

    /**
     * Major cities by province code
     */
    protected $citiesByProvince = [
        'AB' => ['Calgary', 'Edmonton', 'Red Deer', 'Lethbridge', 'Medicine Hat'],
        'BC' => ['Vancouver', 'Victoria', 'Surrey', 'Burnaby', 'Richmond'],
        'MB' => ['Winnipeg', 'Brandon', 'Thompson', 'Steinbach', 'Portage la Prairie'],
        'NB' => ['Saint John', 'Moncton', 'Fredericton', 'Dieppe', 'Miramichi'],
        'NL' => ['St. John\'s', 'Mount Pearl', 'Corner Brook', 'Grand Falls-Windsor'],
        'NS' => ['Halifax', 'Dartmouth', 'Sydney', 'Truro', 'New Glasgow'],
        'NT' => ['Yellowknife', 'Hay River', 'Inuvik', 'Fort Smith'],
        'NU' => ['Iqaluit', 'Rankin Inlet', 'Arviat', 'Baker Lake'],
        'ON' => ['Toronto', 'Ottawa', 'Mississauga', 'Hamilton', 'London'],
        'PE' => ['Charlottetown', 'Summerside', 'Stratford', 'Cornwall'],
        'QC' => ['Montreal', 'Quebec City', 'Laval', 'Gatineau', 'Longueuil'],
        'SK' => ['Saskatoon', 'Regina', 'Prince Albert', 'Moose Jaw', 'Swift Current'],
        'YT' => ['Whitehorse', 'Dawson City', 'Watson Lake', 'Haines Junction']
    ];

    public function definition(): array
    {
        // Get a random province and city
        $provinceCode = array_rand($this->citiesByProvince);
        $cityName = $this->citiesByProvince[$provinceCode][array_rand($this->citiesByProvince[$provinceCode])];

        return [
            'city_name' => $cityName,
            'slug' => str($cityName)->slug(),
            'created_by' => User::factory(),
        ];
    }

    /**
     * Configure the factory to create cities for a specific province
     */
    public function forProvince(string $provinceCode): static
    {
        return $this->state(function (array $attributes) use ($provinceCode) {
            $cityName = $this->citiesByProvince[$provinceCode][array_rand($this->citiesByProvince[$provinceCode])];
            return [
                'city_name' => $cityName,
                'slug' => str($cityName)->slug(),
            ];
        });
    }
} 