<?php

namespace Database\Factories\Location;

use App\Models\Location\State;
use App\Models\User\User;
use Illuminate\Database\Eloquent\Factories\Factory;

class StateFactory extends Factory
{
    protected $model = State::class;

    /**
     * Canadian provinces and territories
     */
    protected $provinces = [
        'AB' => 'Alberta',
        'BC' => 'British Columbia',
        'MB' => 'Manitoba',
        'NB' => 'New Brunswick',
        'NL' => 'Newfoundland and Labrador',
        'NS' => 'Nova Scotia',
        'NT' => 'Northwest Territories',
        'NU' => 'Nunavut',
        'ON' => 'Ontario',
        'PE' => 'Prince Edward Island',
        'QC' => 'Quebec',
        'SK' => 'Saskatchewan',
        'YT' => 'Yukon'
    ];

    public function definition(): array
    {
        $provinceCode = array_rand($this->provinces);
        $provinceName = $this->provinces[$provinceCode];
        
        return [
            'state_name' => $provinceName,
            'state_code' => $provinceCode,
            'slug' => str($provinceName)->slug(),
            'created_by' => User::factory(),
        ];
    }

    /**
     * Create a state with a specific province code
     */
    public function forProvince(string $provinceCode): static
    {
        return $this->state(function (array $attributes) use ($provinceCode) {
            return [
                'state_name' => $this->provinces[$provinceCode],
                'state_code' => $provinceCode,
                'slug' => str($this->provinces[$provinceCode])->slug(),
            ];
        });
    }
} 